/* rc-vp1027.c - Keytable for Twinhan VP-1027 Remote Controller
 *
 * Copyright (c) 2010 by Igor M. Liplianin <liplianin@me.by>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <media/rc-map.h>

/* Twinhan vp1027 DVB-S remote
   Sergey _Kash_ Ivanov 123kash@gmail.com
*/
static struct ir_scancode vp1027[] = {
	{ 0x16, KEY_POWER2 },
	{ 0x17, KEY_FAVORITES },
	{ 0x0f, KEY_TEXT },
	{ 0x48, KEY_INFO},
	{ 0x1c, KEY_EPG },
	{ 0x04, KEY_LIST },

	{ 0x03, KEY_1 },
	{ 0x01, KEY_2 },
	{ 0x06, KEY_3 },
	{ 0x09, KEY_4 },
	{ 0x1d, KEY_5 },
	{ 0x1f, KEY_6 },
	{ 0x0d, KEY_7 },
	{ 0x19, KEY_8 },
	{ 0x1b, KEY_9 },
	{ 0x15, KEY_0 },

	{ 0x0c, KEY_CANCEL },
	{ 0x4a, KEY_CLEAR },
	{ 0x13, KEY_BACKSPACE },
	{ 0x00, KEY_TAB },

	{ 0x4b, KEY_UP },
	{ 0x51, KEY_DOWN },
	{ 0x4e, KEY_LEFT },
	{ 0x52, KEY_RIGHT },
	{ 0x4f, KEY_ENTER },

	{ 0x1e, KEY_VOLUMEUP },
	{ 0x0a, KEY_VOLUMEDOWN },
	{ 0x02, KEY_CHANNELDOWN },
	{ 0x05, KEY_CHANNELUP },
	{ 0x11, KEY_RECORD },

	{ 0x14, KEY_PLAY },
	{ 0x4c, KEY_PAUSE },
	{ 0x1a, KEY_STOP },
	{ 0x40, KEY_REWIND },
	{ 0x12, KEY_FASTFORWARD },
	{ 0x41, KEY_PREVIOUSSONG },
	{ 0x42, KEY_NEXTSONG },
	{ 0x54, KEY_SAVE },
	{ 0x50, KEY_LANGUAGE },
	{ 0x47, KEY_MEDIA },
	{ 0x4d, KEY_SCREEN },
	{ 0x43, KEY_SUBTITLE },
	{ 0x10, KEY_MUTE },
	{ 0x49, KEY_AUDIO },
	{ 0x07, KEY_SLEEP },
	{ 0x08, KEY_VIDEO },
	{ 0x0e, KEY_AGAIN },
	{ 0x45, KEY_EQUAL },
	{ 0x46, KEY_MINUS },
	{ 0x18, KEY_RED },
	{ 0x53, KEY_GREEN },
	{ 0x5e, KEY_YELLOW },
	{ 0x5f, KEY_BLUE },
};

static struct rc_keymap vp1027_map = {
	.map = {
		.scan    = vp1027,
		.size    = ARRAY_SIZE(vp1027),
		.ir_type = IR_TYPE_UNKNOWN,	/* Legacy IR type */
		.name    = RC_MAP_VP1027,
	}
};

static int __init init_rc_map_vp1027(void)
{
	return ir_register_map(&vp1027_map);
}

static void __exit exit_rc_map_vp1027(void)
{
	ir_unregister_map(&vp1027_map);
}

module_init(init_rc_map_vp1027)
module_exit(exit_rc_map_vp1027)

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Igor M. Liplianin <liplianin@me.by>");
